//
//  OPSprite.h
//  The Obfuscated Path
//
//  Created by ss2cire on 12/6/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <OpenGL/gl.h>
#import "OPTypes.h"

#define MOVE_SPEED (240 * UPDATE_INTERVAL)

@interface OPSprite : NSObject
{
	OPPoint		location;
	OPSize		size;
	GLuint		textureID;

	int			moveSpeed;
	int			numberOfUpdates;
	BOOL		visible;
}

- (id)initWithLocation:(OPPoint)inLocation andSize:(OPSize)inSize;
- (void)setTexture:(GLuint)inTextureId;
- (void)draw;
- (void)update;

- (void)setLocationX:(int)inX;
- (void)setLocationY:(int)inY;

- (OPPoint)location;
- (int)locationX;
- (int)locationY;



- (void)update;
- (OPRect)collisionRect;

- (BOOL)willNotCollide:(OPSprite *)spriteToCheck;
- (void)setVisible:(BOOL)inValue;
- (BOOL)isVisible;
@end
